# Add users
ldapadd -H ldap://localhost:1389 -x -D "cn=admin,dc=example,dc=org" -w changeme-ldap -f users.ldif

# Set passwords
for i in {0..9}
do
    for j in {0..9}
    do
        ldappasswd -H ldap://localhost:1389 -x -D "cn=admin,dc=example,dc=org" -w changeme-ldap -s changeme "cn=user$i$j,ou=users,dc=example,dc=org"
    done
done

# Add groups OU
ldapadd -H ldap://localhost:1389 -x -D "cn=admin,dc=example,dc=org" -w changeme-ldap -f ou.ldif

# Add groups with membership
ldapadd -H ldap://localhost:1389 -x -D "cn=admin,dc=example,dc=org" -w changeme-ldap -f groups.ldif

# Take a look to see if everything was created properly
# ldapsearch -H ldap://localhost:1389 -x -D "cn=admin,dc=example,dc=org" -w changeme-ldap -b 'dc=example,dc=org' -LLL

# Clean up example
# ldapdelete -H ldap://localhost:1389 -x -D "cn=admin,dc=example,dc=org" -w changeme-ldap cn=engineering,ou=groups,dc=example,dc=org
